* called by industryregs.do

/* look by industry
   look at whether value-added is what overall GDP (components) would have predicted
   look at whether L is what value-added and labor costs per worker would have predicted
   do decomposition */

* reduced form L regression on GDP comps and wage
* forget reduced form - (see decomp_nolags.do for old version)

* VA regression and get residual
reg lvax_r lcons_r linvest_r lgovt_r lexports_r limports_r  year_q if year<=2003
newey lvax_r lcons_r linvest_r lgovt_r lexports_r limports_r  year_q if year<=2003,lag(4)
predict lvaxhat
predict lvaxres,resid
label var lvaxres "prediction error in VA"

* employment regression - four lags of value-added
reg lemplx lcostperladj_rl lvax_rl lvax_rl2 lvax_rl3 lvax_rl4 year_q if year<=2003
newey lemplx lcostperladj_rl lvax_rl lvax_rl2 lvax_rl3 lvax_rl4 year_q if year<=2003,lag(4)
predict lemplxhat
predict lemplxres,resid
label var lemplxres "prediction error in L, VA on rhs"
* use coefficient from this to normalize VA prediction error appropriately
sort year_q
gen vaerrornorm=_b[lvax_rl]*lvaxres[_n-1]+_b[lvax_rl2]*lvaxres[_n-2]+_b[lvax_rl3]*lvaxres[_n-3]+_b[lvax_rl4]*lvaxres[_n-4]

* now check differences in these
gen dlemplxres=.
gen dvaerrornorm=.
gen dlemplxhat=.
gen dlvaxhat=.
gen dlvaxres=.
gen dlemplx=.
gen dlvax=.
* boom Q3 2005- Q3 2008 (if looking at va varibles, lag ONE quarters)
* START Q2 2005 INSTEAD, so lag 13 Qs not 12
replace dlvax=lvax_r-lvax_r[_n-13] if year==2008&quarter==2
replace dlvaxhat=lvaxhat-lvaxhat[_n-13] if year==2008&quarter==2
replace dlvaxres=lvaxres-lvaxres[_n-13] if year==2008&quarter==2
replace dvaerrornorm=vaerrornorm-vaerrornorm[_n-13] if year==2008&quarter==3
replace dlemplx=lemplx-lemplx[_n-13] if year==2008&quarter==3
replace dlemplxhat=lemplxhat-lemplxhat[_n-13] if year==2008&quarter==3
replace dlemplxres=lemplxres-lemplxres[_n-13] if year==2008&quarter==3

* bust Q3 2008 - Q3 2009
replace dlvax=lvax_r-lvax_r[_n-4] if year==2009&quarter==2
replace dlvaxhat=lvaxhat-lvaxhat[_n-4] if year==2009&quarter==2
replace dlvaxres=lvaxres-lvaxres[_n-4] if year==2009&quarter==2
replace dvaerrornorm=vaerrornorm-vaerrornorm[_n-4] if year==2009&quarter==3
replace dlemplx=lemplx-lemplx[_n-4] if year==2009&quarter==3
replace dlemplxhat=lemplxhat-lemplxhat[_n-4] if year==2009&quarter==3
replace dlemplxres=lemplxres-lemplxres[_n-4] if year==2009&quarter==3

* recovery Q3 2009 - Q3 2010
replace dlvax=lvax_r-lvax_r[_n-4] if year==2010&quarter==2
replace dlvaxhat=lvaxhat-lvaxhat[_n-4] if year==2010&quarter==2
replace dlvaxres=lvaxres-lvaxres[_n-4] if year==2010&quarter==2
replace dvaerrornorm=vaerrornorm-vaerrornorm[_n-4] if year==2010&quarter==3
replace dlemplx=lemplx-lemplx[_n-4] if year==2010&quarter==3
replace dlemplxhat=lemplxhat-lemplxhat[_n-4] if year==2010&quarter==3
replace dlemplxres=lemplxres-lemplxres[_n-4] if year==2010&quarter==3


gen emplerrorshare=dlemplxres/(dlemplxres+dvaerrornorm)
*list lhs rhs if year>2007
*list dlemplx dlemplxhat dlvax dlvaxhat emplerrorshare if year>2007
* don't even report reduced form
di "first dates"
list dlemplx dlemplxhat dlemplxres dlvax dlvaxhat dvaerrornorm emplerrorshare if year>2007
drop dlemplxres dvaerrornorm dlemplxhat dlvaxhat dlvaxres dlemplx dlvax emplerrorshare

* repeat for different set of dates corresponding exactly to peaks/troughs
* of manuf employment
* boom Q1 2006-Q3 2008
* bust Q3 2008-Q1 2010
* recovery, to extent there is one Q1 2010-Q3 2010


* now check differences in these
gen dlemplxres=.
gen dvaerrornorm=.
gen dlemplxhat=.
gen dlvaxhat=.
gen dlvaxres=.
gen dlemplx=.
gen dlvax=.
* boom Q1 2006- Q3 2008 (if looking at va varibles, lag ONE quarters)
replace dlvax=lvax_r-lvax_r[_n-10] if year==2008&quarter==2
replace dlvaxhat=lvaxhat-lvaxhat[_n-10] if year==2008&quarter==2
replace dlvaxres=lvaxres-lvaxres[_n-10] if year==2008&quarter==2
replace dvaerrornorm=vaerrornorm-vaerrornorm[_n-10] if year==2008&quarter==3
replace dlemplx=lemplx-lemplx[_n-10] if year==2008&quarter==3
replace dlemplxhat=lemplxhat-lemplxhat[_n-10] if year==2008&quarter==3
replace dlemplxres=lemplxres-lemplxres[_n-10] if year==2008&quarter==3

* bust Q3 2008 - Q1 2010
replace dlvax=lvax_r-lvax_r[_n-6] if year==2009&quarter==4
replace dlvaxhat=lvaxhat-lvaxhat[_n-6] if year==2009&quarter==4
replace dlvaxres=lvaxres-lvaxres[_n-6] if year==2009&quarter==4
replace dvaerrornorm=vaerrornorm-vaerrornorm[_n-6] if year==2010&quarter==1
replace dlemplx=lemplx-lemplx[_n-6] if year==2010&quarter==1
replace dlemplxhat=lemplxhat-lemplxhat[_n-6] if year==2010&quarter==1
replace dlemplxres=lemplxres-lemplxres[_n-6] if year==2010&quarter==1

* recovery Q1 2010 - Q3 2010
replace dlvax=lvax_r-lvax_r[_n-2] if year==2010&quarter==2
replace dlvaxhat=lvaxhat-lvaxhat[_n-2] if year==2010&quarter==2
replace dlvaxres=lvaxres-lvaxres[_n-2] if year==2010&quarter==2
replace dvaerrornorm=vaerrornorm-vaerrornorm[_n-2] if year==2010&quarter==3
replace dlemplx=lemplx-lemplx[_n-2] if year==2010&quarter==3
replace dlemplxhat=lemplxhat-lemplxhat[_n-2] if year==2010&quarter==3
replace dlemplxres=lemplxres-lemplxres[_n-2] if year==2010&quarter==3

gen emplerrorshare=dlemplxres/(dlemplxres+dvaerrornorm)
di "second dates"
list dlemplx dlemplxhat dlemplxres dlvax dlvaxhat dvaerrornorm emplerrorshare if year>2007





